/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.io.IOException;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.presentations.mindmapmode.MapPresentations;
import org.freeplane.features.presentations.mindmapmode.NamedElementCollection;
import org.freeplane.features.presentations.mindmapmode.Presentation;
import org.freeplane.features.presentations.mindmapmode.Slide;
import org.freeplane.n3.nanoxml.XMLElement;

class PresentationWriter {
    private static final String HOOK = "hook";
    private MapModel map;

    public PresentationWriter(MapModel map) {
        this.map = map;
    }

    void writeContent(ITreeWriter writer, IExtension extension) throws IOException {
        MapPresentations mapPresentations = (MapPresentations)extension;
        NamedElementCollection<Presentation> presentations = mapPresentations.presentations;
        if (presentations.getSize() > 0) {
            XMLElement xmlPresentations = new XMLElement(HOOK);
            xmlPresentations.setAttribute("NAME", "presentations");
            for (int i = 0; i < presentations.getSize(); ++i) {
                Presentation p = presentations.getElement(i);
                this.writePresentation(xmlPresentations, p);
            }
            writer.addElement(null, xmlPresentations);
        }
    }

    private void writePresentation(XMLElement xmlPresentations, Presentation p) {
        XMLElement xmlPresentation = xmlPresentations.createElement("presentation");
        xmlPresentation.setAttribute("NAME", p.getName());
        for (int i = 0; i < p.slides.getSize(); ++i) {
            this.writeSlide(xmlPresentation, p.slides.getElement(i));
        }
        xmlPresentations.addChild(xmlPresentation);
    }

    private void writeSlide(XMLElement xmlPresentation, Slide s) {
        ASelectableCondition filterCondition;
        float zoom;
        IMapSelection.NodePosition placedNodePosition;
        String placedNodeId;
        String rootNodeId;
        XMLElement xmlSlide = xmlPresentation.createElement("slide");
        xmlPresentation.addChild(xmlSlide);
        xmlSlide.setAttribute("NAME", s.getName());
        if (s.showsAncestors()) {
            xmlSlide.setAttribute("showsAncestors", "true");
        }
        if (s.showsDescendants()) {
            xmlSlide.setAttribute("showsDescendants", "true");
        }
        if (s.showsOnlySpecificNodes()) {
            xmlSlide.setAttribute("showsOnlySpecificNodes", "true");
        }
        if (s.changesZoom()) {
            xmlSlide.setAttribute("changesZoom", "true");
        }
        if ((rootNodeId = s.getRootNodeId()) != null) {
            xmlSlide.setAttribute("rootNodeId", rootNodeId);
        }
        if ((placedNodeId = s.getPlacedNodeId()) != null) {
            xmlSlide.setAttribute("placedNodeId", placedNodeId);
        }
        if ((placedNodePosition = s.getPlacedNodePosition()) != IMapSelection.NodePosition.CENTER) {
            xmlSlide.setAttribute("placedNodePosition", placedNodePosition.name());
        }
        if ((zoom = s.getZoom()) != 1.0f) {
            xmlSlide.setAttribute("zoom", Float.toString(zoom));
        }
        if ((filterCondition = s.getFilterCondition()) != null) {
            XMLElement xmlCondition = new XMLElement("SlideCondition");
            filterCondition.toXml(xmlCondition);
            xmlSlide.addChild(xmlCondition);
        }
        XMLElement xmlNodes = new XMLElement("NodesOnSlide");
        for (String nodeId : s.getSelectedNodeIds()) {
            if (this.map.getNodeForID(nodeId) == null) continue;
            XMLElement xmlNode = new XMLElement("NodeOnSlide");
            xmlNode.setAttribute("nodeId", nodeId);
            xmlNodes.addChild(xmlNode);
        }
        if (xmlNodes.hasChildren()) {
            xmlSlide.addChild(xmlNodes);
        }
        if (s.foldsNodes()) {
            XMLElement xmlFoldedNodes = new XMLElement("FoldedNodes");
            for (String nodeId : s.getFoldedNodeIds()) {
                if (this.map.getNodeForID(nodeId) == null) continue;
                XMLElement xmlNode = new XMLElement("NodeOnSlide");
                xmlNode.setAttribute("nodeId", nodeId);
                xmlFoldedNodes.addChild(xmlNode);
            }
            xmlSlide.addChild(xmlFoldedNodes);
        }
    }
}

