/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.SwingUtilities;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.map.MapView;

public class ViewerLayoutManager
implements LayoutManager {
    private float zoom;
    private ExternalResource externalResource;
    private Dimension originalSize;

    public ViewerLayoutManager(float zoom, ExternalResource externalResource, Dimension originalSize) {
        this.zoom = zoom;
        this.externalResource = externalResource;
        this.originalSize = originalSize;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!parent.isPreferredSizeSet()) {
            throw new IllegalStateException("preferred size not set for " + parent);
        }
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, parent);
        if (mapView == null) {
            return;
        }
        float newZoom = mapView.getZoom();
        if (this.zoom != newZoom) {
            this.zoom = newZoom;
            Dimension preferredSize = this.calculatePreferredSize();
            parent.setPreferredSize(preferredSize);
        }
    }

    public Dimension calculatePreferredSize() {
        int width = Math.round((float)this.originalSize.width * this.externalResource.getZoom() * this.zoom);
        int height = Math.round((float)this.originalSize.height * this.externalResource.getZoom() * this.zoom);
        Dimension preferredSize = new Dimension(Math.max(1, width), Math.max(1, height));
        return preferredSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return parent.getPreferredSize();
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

