/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class OSKeyBindingManager {
    private static final UIDefaults systemDefaults;
    private static final Set<LookAndFeel> patchedLAFs;
    private static final List<String> inputMapKeys;
    private static final List<String> actionMapKeys;
    private static final List<String> editableComponentInputMaps;

    public static void initialize() {
    }

    public static void applyToCurrentLookAndFeel() {
        if (!OSKeyBindingManager.shouldApplyChanges()) {
            return;
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        UIDefaults targetDefaults = UIManager.getLookAndFeelDefaults();
        Object[][] preservedBindings = OSKeyBindingManager.collectPreservedBindings(targetDefaults);
        OSKeyBindingManager.applySystemDefaults(targetDefaults);
        OSKeyBindingManager.restorePreservedBindings(targetDefaults, preservedBindings);
        OSKeyBindingManager.ensureF2EditBinding(targetDefaults);
        patchedLAFs.add(laf);
    }

    private static boolean shouldApplyChanges() {
        if (systemDefaults == null) {
            return false;
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf.getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
            return false;
        }
        return !patchedLAFs.contains(laf);
    }

    private static Object[][] collectPreservedBindings(UIDefaults targetDefaults) {
        List<KeyStroke> preservedKeys = OSKeyBindingManager.preservedKeys();
        Object[][] preservedBindings = new Object[inputMapKeys.size() * preservedKeys.size()][3];
        int bindingCount = 0;
        for (String mapKey : inputMapKeys) {
            Object mapObj = targetDefaults.get(mapKey);
            if (!(mapObj instanceof InputMap)) continue;
            InputMap targetMap = (InputMap)mapObj;
            for (KeyStroke keyStroke : preservedKeys) {
                Object action = targetMap.get(keyStroke);
                if (action == null) continue;
                preservedBindings[bindingCount][0] = mapKey;
                preservedBindings[bindingCount][1] = keyStroke;
                preservedBindings[bindingCount][2] = action;
                ++bindingCount;
            }
        }
        if (bindingCount < preservedBindings.length) {
            Object[][] trimmedBindings = new Object[bindingCount][3];
            System.arraycopy(preservedBindings, 0, trimmedBindings, 0, bindingCount);
            return trimmedBindings;
        }
        return preservedBindings;
    }

    private static void applySystemDefaults(UIDefaults targetDefaults) {
        Object targetValue;
        Object systemValue;
        for (String key : inputMapKeys) {
            systemValue = systemDefaults.get(key);
            if (!(systemValue instanceof InputMap) || !(systemValue instanceof UIResource) || !((targetValue = targetDefaults.get(key)) instanceof UIResource)) continue;
            targetDefaults.put(key, systemValue);
        }
        for (String key : actionMapKeys) {
            systemValue = systemDefaults.get(key);
            if (!(systemValue instanceof ActionMap) || !(systemValue instanceof UIResource) || !((targetValue = targetDefaults.get(key)) instanceof UIResource)) continue;
            targetDefaults.put(key, systemValue);
        }
    }

    private static void restorePreservedBindings(UIDefaults targetDefaults, Object[][] preservedBindings) {
        for (Object[] binding : preservedBindings) {
            String mapKey = (String)binding[0];
            Object mapObj = targetDefaults.get(mapKey);
            if (!(mapObj instanceof InputMap)) continue;
            InputMap map = (InputMap)mapObj;
            KeyStroke keyStroke = (KeyStroke)binding[1];
            Object action = binding[2];
            map.put(keyStroke, action);
        }
    }

    private static List<KeyStroke> preservedKeys() {
        ArrayList<KeyStroke> preservedKeys = new ArrayList<KeyStroke>();
        String[] arrowKeys = new String[]{"UP", "DOWN", "LEFT", "RIGHT"};
        String[] modifiers = new String[]{"", "shift", "ctrl", "meta"};
        for (String arrow : arrowKeys) {
            for (String modifier : modifiers) {
                String keyStrokeStr = modifier.isEmpty() ? arrow : modifier + " " + arrow;
                preservedKeys.add(KeyStroke.getKeyStroke(keyStrokeStr));
            }
        }
        return preservedKeys;
    }

    private static void ensureF2EditBinding(UIDefaults defaults) {
        KeyStroke f2 = KeyStroke.getKeyStroke("F2");
        for (String key : editableComponentInputMaps) {
            Object mapObj = defaults.get(key);
            if (!(mapObj instanceof InputMap)) continue;
            InputMap im = (InputMap)mapObj;
            if (!key.equals("Tree.focusInputMap") && !key.equals("Table.ancestorInputMap") && !key.equals("List.focusInputMap")) continue;
            im.put(f2, "startEditing");
        }
    }

    private OSKeyBindingManager() {
    }

    static {
        UIDefaults captured;
        patchedLAFs = Collections.newSetFromMap(new WeakHashMap());
        inputMapKeys = Arrays.asList("TextField.focusInputMap", "TextArea.focusInputMap", "PasswordField.focusInputMap", "EditorPane.focusInputMap", "FormattedTextField.focusInputMap", "Spinner.editorInputMap", "ComboBox.ancestorInputMap", "Tree.focusInputMap", "List.focusInputMap", "Table.ancestorInputMap", "TableHeader.ancestorInputMap", "CheckBox.focusInputMap", "RadioButton.focusInputMap", "Button.focusInputMap", "ToggleButton.focusInputMap", "RootPane.defaultButtonWindowKeyBindings");
        actionMapKeys = Arrays.asList("TextField.actionMap", "TextArea.actionMap", "PasswordField.actionMap", "EditorPane.actionMap", "FormattedTextField.actionMap", "Spinner.actionMap", "ComboBox.actionMap", "Tree.actionMap", "List.actionMap", "Table.actionMap", "TableHeader.actionMap", "CheckBox.actionMap", "RadioButton.actionMap", "Button.actionMap", "ToggleButton.actionMap", "RootPane.actionMap");
        editableComponentInputMaps = Arrays.asList("Tree.focusInputMap", "List.focusInputMap", "Table.ancestorInputMap");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            captured = UIManager.getLookAndFeelDefaults();
        }
        catch (Exception e) {
            e.printStackTrace();
            captured = new UIDefaults();
        }
        systemDefaults = captured;
    }
}

