/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;

public class OptionPanelController {
    private Vector<IPropertyControl> propertyControls = new Vector();
    private List<ActionListener> list = new ArrayList<ActionListener>();
    private List<PropertyLoadListener> loadListener = new ArrayList<PropertyLoadListener>();

    public void addPropertyLoadListener(PropertyLoadListener listener) {
        this.loadListener.add(listener);
    }

    public void addButtonListener(ActionListener listener) {
        this.list.add(listener);
    }

    public void actionPerformed(ActionEvent e) {
        for (ActionListener listener : this.list) {
            listener.actionPerformed(e);
        }
    }

    public void setCurrentPropertyControls(Vector<IPropertyControl> props) {
        this.propertyControls = props;
        for (PropertyLoadListener listener : this.loadListener) {
            listener.propertiesLoaded(props);
        }
    }

    public IPropertyControl getPropertyControl(String name) {
        for (IPropertyControl control : this.propertyControls) {
            if (control.getName() == null || !control.getName().equals(name)) continue;
            return control;
        }
        return null;
    }

    public Properties getCurrentOptionProperties() {
        Properties p = new Properties();
        Vector<IPropertyControl> controls = this.propertyControls;
        for (IPropertyControl control : controls) {
            PropertyBean bean;
            String value;
            if (!(control instanceof PropertyBean) || (value = (bean = (PropertyBean)control).getValue()) == null) continue;
            p.setProperty(bean.getName(), value);
        }
        return p;
    }

    public static interface PropertyLoadListener {
        public void propertiesLoaded(Collection<IPropertyControl> var1);
    }
}

