/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class MDCAmbit {
    Set<String> keySet = new HashSet<String>();
    MDCAdapter mdcAdapter;

    public MDCAmbit() {
        this.mdcAdapter = MDC.getMDCAdapter();
    }

    MDCAmbit(MDCAdapter mdcAdapter) {
        this.mdcAdapter = mdcAdapter;
    }

    public MDCAmbit put(String key, String value) {
        this.mdcAdapter.put(key, value);
        this.keySet.add(key);
        return this;
    }

    public MDCAmbit addKey(String key) {
        this.keySet.add(key);
        return this;
    }

    public MDCAmbit addKeys(String ... keys) {
        if (keys == null) {
            return this;
        }
        for (String k : keys) {
            this.keySet.add(k);
        }
        return this;
    }

    public void run(Runnable runnable) {
        try {
            runnable.run();
        }
        finally {
            this.clear();
        }
    }

    public <T> T call(Callable<? extends T> callable) throws Exception {
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        for (String key : this.keySet) {
            this.mdcAdapter.remove(key);
        }
        this.keySet.clear();
    }
}

