/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Ordering;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PluginLoader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLoader.class);
    private final Supplier<T> supplier;

    private PluginLoader(Class<T> pluginType, Map<JavaVersion, String> versionToPlugins, T fallback) {
        this.supplier = Suppliers.memoize(new PluginSupplier(pluginType, versionToPlugins, fallback));
    }

    public static <T> Creator<T> forType(Class<T> pluginType) {
        return new Creator(pluginType);
    }

    public T load() {
        return this.supplier.get();
    }

    private static class PluginSupplier<T>
    implements Supplier<T> {
        private final Class<T> pluginType;
        private final Map<JavaVersion, String> versionToPlugins;
        private final T fallback;

        private PluginSupplier(Class<T> pluginType, Map<JavaVersion, String> versionToPlugins, T fallback) {
            this.pluginType = pluginType;
            this.versionToPlugins = versionToPlugins;
            this.fallback = fallback;
        }

        @Override
        public T get() {
            String currentVersion = System.getProperty("java.version");
            LOG.info("Detected Java version {}", (Object)currentVersion);
            for (JavaVersion version : JavaVersion.sortFromNewestToOldest(this.versionToPlugins.keySet())) {
                if (!version.isLessOrEqualThan(currentVersion)) continue;
                String className = this.versionToPlugins.get((Object)version);
                LOG.debug("Current Java version is compatible to {} => Loading Plugin {}", (Object)version, (Object)className);
                return this.create(className);
            }
            LOG.debug("Using legacy import plugin");
            return this.fallback;
        }

        @MayResolveTypesViaReflection(reason="This only resolves ArchUnit's own classes, it's not dependent on any project classpath")
        private T create(String className) {
            try {
                Class<?> clazz = Class.forName(className);
                this.checkCompatibility(className, clazz);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (T)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PluginLoadingFailedException(e, "Couldn't load plugin of type %s", className);
            }
        }

        private void checkCompatibility(String className, Class<?> clazz) {
            if (!this.pluginType.isAssignableFrom(clazz)) {
                throw new PluginLoadingFailedException("Class %s must implement %s", className, this.pluginType.getName());
            }
        }
    }

    @Internal
    public static class Creator<T> {
        private final Map<JavaVersion, String> versionToPlugins = new HashMap<JavaVersion, String>();
        private final Class<T> pluginType;

        private Creator(Class<T> pluginType) {
            this.pluginType = pluginType;
        }

        private Creator<T> addPlugin(JavaVersion version, String pluginClassName) {
            this.versionToPlugins.put(Preconditions.checkNotNull(version), Preconditions.checkNotNull(pluginClassName));
            return this;
        }

        public PluginLoader<T> fallback(T fallback) {
            return new PluginLoader(this.pluginType, this.versionToPlugins, fallback);
        }

        public PluginEntry ifVersionGreaterOrEqualTo(JavaVersion version) {
            return new PluginEntry(version);
        }

        @Internal
        public class PluginEntry {
            private final JavaVersion version;

            private PluginEntry(JavaVersion version) {
                this.version = version;
            }

            public Creator<T> load(String pluginClassName) {
                return Creator.this.addPlugin(this.version, pluginClassName);
            }
        }
    }

    static class PluginLoadingFailedException
    extends RuntimeException {
        PluginLoadingFailedException(String message, Object ... args) {
            super(String.format(message, args));
        }

        PluginLoadingFailedException(Exception e, String message, Object ... args) {
            super(String.format(message, args), e);
        }
    }

    @Internal
    public static enum JavaVersion {
        JAVA_9(9),
        JAVA_14(14),
        JAVA_21(21);

        private final int releaseVersion;
        private static final Ordering<JavaVersion> FROM_NEWEST_TO_OLDEST_ORDERING;
        private static final Pattern VERSION_PATTERN;

        private JavaVersion(int releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public boolean isLessOrEqualThan(String version) {
            return this.releaseVersion <= JavaVersion.parseJavaReleaseVersion(version);
        }

        static List<JavaVersion> sortFromNewestToOldest(Set<JavaVersion> javaVersions) {
            return FROM_NEWEST_TO_OLDEST_ORDERING.sortedCopy(javaVersions);
        }

        private static int parseJavaReleaseVersion(String version) {
            String versionToParse = version.startsWith("1.") ? version.substring(2) : version;
            Matcher matcher = VERSION_PATTERN.matcher(versionToParse);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Can't parse Java version " + version);
            }
            return Integer.parseInt(matcher.group(1));
        }

        static {
            FROM_NEWEST_TO_OLDEST_ORDERING = Ordering.natural().reverse();
            VERSION_PATTERN = Pattern.compile("^(\\d+).*");
        }
    }
}

