/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FObj;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.WhitespaceManagementPenalty;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

class PageBreakingAlgorithm
extends BreakingAlgorithm {
    private static Log log = LogFactory.getLog(PageBreakingAlgorithm.class);
    private final LayoutManager topLevelLM;
    private final PageProvider pageProvider;
    private final PageBreakingLayoutListener layoutListener;
    private LinkedList<AbstractBreaker.PageBreakPosition> pageBreaks;
    private List<List<KnuthElement>> footnotesList;
    private List<Integer> lengthList;
    private int totalFootnotesLength;
    private int insertedFootnotesLength;
    private boolean footnotesPending;
    private boolean newFootnotes;
    private int firstNewFootnoteIndex;
    private int footnoteListIndex;
    private int footnoteElementIndex = -1;
    private final int splitFootnoteDemerits = 5000;
    private final int deferredFootnoteDemerits = 10000;
    private MinOptMax footnoteSeparatorLength;
    private int storedPrevBreakIndex = -1;
    private int storedBreakIndex = -1;
    private boolean storedValue;
    private boolean autoHeight;
    private boolean favorSinglePart;
    private int ipdDifference;
    private BreakingAlgorithm.KnuthNode bestNodeForIPDChange;
    public BreakingAlgorithm.KnuthNode bestNodeForLastPage;
    private int currentKeepContext = 9;
    private BreakingAlgorithm.KnuthNode lastBeforeKeepContextSwitch;
    private boolean handlingStartOfFloat;
    private boolean handlingEndOfFloat;
    private int floatHeight;
    private BreakingAlgorithm.KnuthNode bestFloatEdgeNode;
    private AbstractBreaker.FloatPosition floatPosition;
    private int previousFootnoteListIndex = -2;
    private int previousFootnoteElementIndex = -2;
    private boolean relayingFootnotes;
    private LayoutContext childLC;

    public PageBreakingAlgorithm(LayoutManager topLevelLM, PageProvider pageProvider, PageBreakingLayoutListener layoutListener, int alignment, int alignmentLast, MinOptMax footnoteSeparatorLength, boolean partOverflowRecovery, boolean autoHeight, boolean favorSinglePart, LayoutContext childLC) {
        super(alignment, alignmentLast, true, partOverflowRecovery, 0);
        this.topLevelLM = topLevelLM;
        this.pageProvider = pageProvider;
        this.layoutListener = layoutListener;
        this.best = new BestPageRecords();
        this.footnoteSeparatorLength = footnoteSeparatorLength;
        this.autoHeight = autoHeight;
        this.favorSinglePart = favorSinglePart;
        this.childLC = childLC;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.insertedFootnotesLength = 0;
        this.footnoteListIndex = 0;
        this.footnoteElementIndex = -1;
        if (this.topLevelLM instanceof PageSequenceLayoutManager) {
            boolean spanAll;
            PageSequenceLayoutManager pslm = (PageSequenceLayoutManager)this.topLevelLM;
            boolean bl = spanAll = this.childLC != null && this.childLC.getCurrentSpan() == 5;
            if (pslm.handlingStartOfFloat() || pslm.handlingEndOfFloat() || spanAll) {
                pslm.retrieveFootnotes(this);
            }
            if (pslm.handlingStartOfFloat()) {
                this.floatHeight = Math.min(pslm.getFloatHeight(), this.lineWidth - pslm.getFloatYOffset());
            }
            if (pslm.handlingEndOfFloat()) {
                this.totalWidth += pslm.getOffsetDueToFloat() + this.insertedFootnotesLength;
            } else if (spanAll) {
                this.totalWidth += this.insertedFootnotesLength;
            }
        }
    }

    @Override
    protected BreakingAlgorithm.KnuthNode recoverFromTooLong(BreakingAlgorithm.KnuthNode lastTooLong) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recovering from too long: " + lastTooLong));
            log.debug((Object)("\tlastTooShort = " + this.getLastTooShort()));
            log.debug((Object)("\tlastBeforeKeepContextSwitch = " + this.lastBeforeKeepContextSwitch));
            log.debug((Object)("\tcurrentKeepContext = " + AbstractBreaker.getBreakClassName(this.currentKeepContext)));
        }
        if (this.lastBeforeKeepContextSwitch == null || this.currentKeepContext == 9) {
            return super.recoverFromTooLong(lastTooLong);
        }
        BreakingAlgorithm.KnuthNode node = this.lastBeforeKeepContextSwitch;
        this.lastBeforeKeepContextSwitch = null;
        while (!this.pageProvider.endPage(node.line - 1)) {
            log.trace((Object)"Adding node for empty column");
            node = this.createNode(node.position, node.line + 1, 1, 0, 0, 0, 0.0, 0, 0, 0, 0.0, node);
        }
        return node;
    }

    @Override
    protected BreakingAlgorithm.KnuthNode compareNodes(BreakingAlgorithm.KnuthNode node1, BreakingAlgorithm.KnuthNode node2) {
        if (node1 == null || node2 == null) {
            return node1 == null ? node2 : node1;
        }
        if (this.pageProvider != null) {
            if (this.pageProvider.endPage(node1.line - 1) && !this.pageProvider.endPage(node2.line - 1)) {
                return node1;
            }
            if (this.pageProvider.endPage(node2.line - 1) && !this.pageProvider.endPage(node1.line - 1)) {
                return node2;
            }
        }
        return super.compareNodes(node1, node2);
    }

    @Override
    protected BreakingAlgorithm.KnuthNode createNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink, double adjustRatio, int availableShrink, int availableStretch, int difference, double totalDemerits, BreakingAlgorithm.KnuthNode previous) {
        return new KnuthPageNode(position, line, fitness, totalWidth, totalStretch, totalShrink, this.insertedFootnotesLength, this.totalFootnotesLength, this.footnoteListIndex, this.footnoteElementIndex, adjustRatio, availableShrink, availableStretch, difference, totalDemerits, previous);
    }

    @Override
    protected BreakingAlgorithm.KnuthNode createNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink) {
        return new KnuthPageNode(position, line, fitness, totalWidth, totalStretch, totalShrink, ((BestPageRecords)this.best).getInsertedFootnotesLength(fitness), ((BestPageRecords)this.best).getTotalFootnotesLength(fitness), ((BestPageRecords)this.best).getFootnoteListIndex(fitness), ((BestPageRecords)this.best).getFootnoteElementIndex(fitness), this.best.getAdjust(fitness), this.best.getAvailableShrink(fitness), this.best.getAvailableStretch(fitness), this.best.getDifference(fitness), this.best.getDemerits(fitness), this.best.getNode(fitness));
    }

    @Override
    protected void handleBox(KnuthBox box) {
        super.handleBox(box);
        if (box instanceof KnuthBlockBox && ((KnuthBlockBox)box).hasAnchors()) {
            this.handleFootnotes(((KnuthBlockBox)box).getElementLists());
            if (!this.newFootnotes) {
                this.newFootnotes = true;
                this.firstNewFootnoteIndex = this.footnotesList.size() - 1;
            }
        }
        if (box instanceof KnuthBlockBox && ((KnuthBlockBox)box).hasFloatAnchors()) {
            this.handlingStartOfFloat = true;
        }
        if (this.floatHeight != 0 && this.totalWidth >= this.floatHeight) {
            this.handlingEndOfFloat = true;
        }
    }

    @Override
    protected void handlePenaltyAt(KnuthPenalty penalty, int position, int allowedBreaks) {
        int breakClass;
        super.handlePenaltyAt(penalty, position, allowedBreaks);
        if (penalty.getPenalty() == 1000 && ((breakClass = penalty.getBreakClass()) == 104 || breakClass == 28)) {
            this.considerLegalBreak(penalty, position);
        }
    }

    private void handleFootnotes(List<List<KnuthElement>> elementLists) {
        if (!this.footnotesPending) {
            this.footnotesPending = true;
            this.footnotesList = new ArrayList<List<KnuthElement>>();
            this.lengthList = new ArrayList<Integer>();
            this.totalFootnotesLength = 0;
        }
        if (!this.newFootnotes) {
            this.newFootnotes = true;
            this.firstNewFootnoteIndex = this.footnotesList.size();
        }
        for (List<KnuthElement> noteList : elementLists) {
            int prevLength;
            int noteLength = 0;
            this.footnotesList.add(noteList);
            for (KnuthElement element : noteList) {
                if (!element.isBox() && !element.isGlue()) continue;
                noteLength += element.getWidth();
            }
            int n = prevLength = this.lengthList == null || this.lengthList.isEmpty() ? 0 : ListUtil.getLast(this.lengthList);
            if (this.lengthList != null) {
                this.lengthList.add(prevLength + noteLength);
            }
            this.totalFootnotesLength += noteLength;
        }
    }

    @Override
    protected int restartFrom(BreakingAlgorithm.KnuthNode restartingNode, int currentIndex) {
        int returnValue = super.restartFrom(restartingNode, currentIndex);
        this.newFootnotes = false;
        if (this.footnotesPending) {
            for (int j = currentIndex; j >= restartingNode.position; --j) {
                KnuthElement resetElement = this.getElement(j);
                if (!(resetElement instanceof KnuthBlockBox) || !((KnuthBlockBox)resetElement).hasAnchors()) continue;
                this.resetFootnotes(((KnuthBlockBox)resetElement).getElementLists());
            }
            assert (restartingNode instanceof KnuthPageNode);
            KnuthPageNode restartingPageNode = (KnuthPageNode)restartingNode;
            this.footnoteElementIndex = restartingPageNode.footnoteElementIndex;
            this.footnoteListIndex = restartingPageNode.footnoteListIndex;
            this.totalFootnotesLength = restartingPageNode.totalFootnotes;
            this.insertedFootnotesLength = restartingPageNode.insertedFootnotes;
        }
        return returnValue;
    }

    private void resetFootnotes(List<List<KnuthElement>> elementLists) {
        for (int i = 0; i < elementLists.size(); ++i) {
            ListUtil.removeLast(this.footnotesList);
            ListUtil.removeLast(this.lengthList);
        }
        if (this.footnotesList.size() == 0) {
            this.footnotesPending = false;
        }
    }

    @Override
    protected void considerLegalBreak(KnuthElement element, int elementIdx) {
        if (element.isPenalty()) {
            int breakClass = ((KnuthPenalty)element).getBreakClass();
            switch (breakClass) {
                case 104: {
                    if (this.currentKeepContext != breakClass) {
                        this.lastBeforeKeepContextSwitch = this.getLastTooShort();
                    }
                    this.currentKeepContext = breakClass;
                    break;
                }
                case 28: {
                    if (this.currentKeepContext != breakClass) {
                        this.lastBeforeKeepContextSwitch = this.getLastTooShort();
                    }
                    this.currentKeepContext = breakClass;
                    break;
                }
                case 9: {
                    this.currentKeepContext = breakClass;
                    break;
                }
            }
        }
        super.considerLegalBreak(element, elementIdx);
        this.newFootnotes = false;
    }

    @Override
    protected boolean elementCanEndLine(KnuthElement element, int line, int difference) {
        if (!element.isPenalty() || this.pageProvider == null) {
            return true;
        }
        KnuthPenalty p = (KnuthPenalty)element;
        if (p.getPenalty() <= 0) {
            return true;
        }
        int context = p.getBreakClass();
        switch (context) {
            case 28: 
            case 75: {
                return p.getPenalty() < 1000;
            }
            case 104: {
                return p.getPenalty() < 1000 || !this.pageProvider.endPage(line - 1);
            }
            case 9: {
                log.debug((Object)"keep is not auto but context is");
                return true;
            }
        }
        if (p.getPenalty() < 1000) {
            log.debug((Object)("Non recognized keep context:" + context));
            return true;
        }
        return false;
    }

    @Override
    protected int computeDifference(BreakingAlgorithm.KnuthNode activeNode, KnuthElement element, int elementIndex) {
        int allFootnotes;
        KnuthPageNode pageNode = (KnuthPageNode)activeNode;
        int actualWidth = this.totalWidth - pageNode.totalWidth;
        actualWidth += pageNode.totalVariantsWidth;
        if (element instanceof WhitespaceManagementPenalty) {
            actualWidth += this.handleWhitespaceManagementPenalty(pageNode, (WhitespaceManagementPenalty)element, elementIndex);
        } else if (element.isPenalty()) {
            actualWidth += element.getWidth();
        }
        if (this.footnotesPending && (allFootnotes = this.totalFootnotesLength - pageNode.insertedFootnotes) > 0) {
            if ((actualWidth += this.footnoteSeparatorLength.getOpt()) + allFootnotes <= this.getLineWidth(activeNode.line)) {
                actualWidth += allFootnotes;
                this.insertedFootnotesLength = pageNode.insertedFootnotes + allFootnotes;
                this.footnoteListIndex = this.footnotesList.size() - 1;
                this.footnoteElementIndex = this.getFootnoteList(this.footnoteListIndex).size() - 1;
            } else {
                int footnoteSplit;
                boolean canDeferOldFN = this.canDeferOldFootnotes(pageNode, elementIndex);
                if ((canDeferOldFN || this.newFootnotes) && (footnoteSplit = this.getFootnoteSplit(pageNode, this.getLineWidth(activeNode.line) - actualWidth, canDeferOldFN)) > 0) {
                    actualWidth += footnoteSplit;
                    this.insertedFootnotesLength = pageNode.insertedFootnotes + footnoteSplit;
                } else {
                    actualWidth += allFootnotes;
                    this.insertedFootnotesLength = pageNode.insertedFootnotes + allFootnotes;
                    this.footnoteListIndex = this.footnotesList.size() - 1;
                    this.footnoteElementIndex = this.getFootnoteList(this.footnoteListIndex).size() - 1;
                }
            }
        }
        int diff = this.getLineWidth(activeNode.line) - actualWidth;
        if (this.autoHeight && diff < 0) {
            return 0;
        }
        return diff;
    }

    private int handleWhitespaceManagementPenalty(KnuthPageNode activeNode, WhitespaceManagementPenalty penalty, int elementIndex) {
        for (WhitespaceManagementPenalty.Variant var : penalty.getVariants()) {
            int difference = this.computeDifference(activeNode, var.getPenalty(), elementIndex);
            double r = this.computeAdjustmentRatio(activeNode, difference);
            if (!(r >= -1.0)) continue;
            activeNode.addVariant(var);
            return var.width;
        }
        return 0;
    }

    private boolean canDeferOldFootnotes(KnuthPageNode node, int contentElementIndex) {
        return this.noBreakBetween(node.position, contentElementIndex) && this.deferredFootnotes(node.footnoteListIndex, node.footnoteElementIndex, node.insertedFootnotes);
    }

    private boolean noBreakBetween(int prevBreakIndex, int breakIndex) {
        if (this.storedPrevBreakIndex == -1 || (prevBreakIndex < this.storedPrevBreakIndex || breakIndex != this.storedBreakIndex || !this.storedValue) && (prevBreakIndex > this.storedPrevBreakIndex || breakIndex < this.storedBreakIndex || this.storedValue)) {
            int index = prevBreakIndex + 1;
            while (!this.par.getElement(index).isBox()) {
                ++index;
            }
            while (!(index >= breakIndex || this.par.getElement(index).isGlue() && this.par.getElement(index - 1).isBox() || this.par.getElement(index).isPenalty() && ((KnuthElement)this.par.getElement(index)).getPenalty() < 1000)) {
                ++index;
            }
            this.storedPrevBreakIndex = prevBreakIndex;
            this.storedBreakIndex = breakIndex;
            this.storedValue = index == breakIndex;
        }
        return this.storedValue;
    }

    private boolean deferredFootnotes(int listIndex, int elementIndex, int length) {
        return this.newFootnotes && this.firstNewFootnoteIndex != 0 && (listIndex < this.firstNewFootnoteIndex - 1 || elementIndex < this.getFootnoteList(listIndex).size() - 1) || length < this.totalFootnotesLength;
    }

    private int getFootnoteSplit(KnuthPageNode activeNode, int availableLength, boolean canDeferOldFootnotes) {
        return this.getFootnoteSplit(activeNode.footnoteListIndex, activeNode.footnoteElementIndex, activeNode.insertedFootnotes, availableLength, canDeferOldFootnotes);
    }

    private int getFootnoteSplit(int prevListIndex, int prevElementIndex, int prevLength, int availableLength, boolean canDeferOldFootnotes) {
        if (availableLength <= 0) {
            return 0;
        }
        int splitLength = 0;
        boolean somethingAdded = false;
        int elementIndex = prevElementIndex;
        int listIndex = prevListIndex;
        if (elementIndex == this.getFootnoteList(listIndex).size() - 1) {
            ++listIndex;
            elementIndex = 0;
        } else {
            ++elementIndex;
        }
        if (this.footnotesList.size() - 1 > listIndex) {
            if (!canDeferOldFootnotes && this.newFootnotes && this.firstNewFootnoteIndex > 0) {
                splitLength = this.lengthList.get(this.firstNewFootnoteIndex - 1) - prevLength;
                listIndex = this.firstNewFootnoteIndex;
                elementIndex = 0;
            }
            while (this.lengthList.get(listIndex) - prevLength <= availableLength) {
                splitLength = this.lengthList.get(listIndex) - prevLength;
                somethingAdded = true;
                ++listIndex;
                elementIndex = 0;
            }
        }
        ListIterator<KnuthElement> noteListIterator = this.getFootnoteList(listIndex).listIterator(elementIndex);
        int prevSplitLength = 0;
        int prevIndex = -1;
        int index = -1;
        block1: while (splitLength <= availableLength) {
            if (somethingAdded) {
                prevSplitLength = splitLength;
                prevIndex = index;
            }
            boolean boxPreceding = false;
            while (noteListIterator.hasNext()) {
                KnuthElement element = noteListIterator.next();
                if (element.isBox()) {
                    boxPreceding = true;
                    if ((splitLength += element.getWidth()) <= prevSplitLength) continue;
                    somethingAdded = true;
                    continue;
                }
                if (element.isGlue()) {
                    if (boxPreceding) {
                        index = noteListIterator.previousIndex();
                        continue block1;
                    }
                    boxPreceding = false;
                    splitLength += element.getWidth();
                    continue;
                }
                if (element.getPenalty() < 1000) {
                    index = noteListIterator.previousIndex();
                    continue block1;
                }
                boxPreceding = false;
            }
        }
        if (!somethingAdded) {
            prevSplitLength = 0;
        } else if (prevSplitLength > 0) {
            this.footnoteListIndex = prevIndex != -1 ? listIndex : listIndex - 1;
            this.footnoteElementIndex = prevIndex != -1 ? prevIndex : this.getFootnoteList(this.footnoteListIndex).size() - 1;
        }
        return prevSplitLength;
    }

    @Override
    protected double computeAdjustmentRatio(BreakingAlgorithm.KnuthNode activeNode, int difference) {
        if (difference > 0) {
            int maxAdjustment = this.totalStretch - activeNode.totalStretch;
            if (((KnuthPageNode)activeNode).insertedFootnotes < this.totalFootnotesLength) {
                maxAdjustment += this.footnoteSeparatorLength.getStretch();
            }
            if (maxAdjustment > 0) {
                return (double)difference / (double)maxAdjustment;
            }
            return 1000.0;
        }
        if (difference < 0) {
            int maxAdjustment = this.totalShrink - activeNode.totalShrink;
            if (((KnuthPageNode)activeNode).insertedFootnotes < this.totalFootnotesLength) {
                maxAdjustment += this.footnoteSeparatorLength.getShrink();
            }
            if (maxAdjustment > 0) {
                return (double)difference / (double)maxAdjustment;
            }
            return -1000.0;
        }
        return 0.0;
    }

    @Override
    protected double computeDemerits(BreakingAlgorithm.KnuthNode activeNode, KnuthElement element, int fitnessClass, double r) {
        double penalty;
        double demerits = 0.0;
        double f = Math.abs(r);
        f = 1.0 + 100.0 * f * f * f;
        demerits = element.isPenalty() ? ((penalty = (double)element.getPenalty()) >= 0.0 ? (f += penalty) * f : (!element.isForcedBreak() ? f * f - penalty * penalty : f * f)) : f * f;
        if (element.isPenalty() && ((KnuthPenalty)element).isPenaltyFlagged() && this.getElement(activeNode.position).isPenalty() && ((KnuthPenalty)this.getElement(activeNode.position)).isPenaltyFlagged()) {
            demerits += (double)this.repeatedFlaggedDemerit;
        }
        if (Math.abs(fitnessClass - activeNode.fitness) > 1) {
            demerits += (double)this.incompatibleFitnessDemerit;
        }
        if (this.footnotesPending) {
            if (this.footnoteListIndex < this.footnotesList.size() - 1) {
                demerits += (double)((this.footnotesList.size() - 1 - this.footnoteListIndex) * 10000);
            }
            if (this.footnoteListIndex < this.footnotesList.size() && this.footnoteElementIndex < this.getFootnoteList(this.footnoteListIndex).size() - 1) {
                demerits += 5000.0;
            }
        }
        return demerits += activeNode.totalDemerits;
    }

    @Override
    protected void finish() {
        for (int i = this.startLine; i < this.endLine; ++i) {
            KnuthPageNode node = (KnuthPageNode)this.getNode(i);
            while (node != null) {
                if (node.insertedFootnotes < this.totalFootnotesLength) {
                    this.createFootnotePages(node);
                }
                node = (KnuthPageNode)node.next;
            }
        }
    }

    private void createFootnotePages(KnuthPageNode lastNode) {
        KnuthPageNode node;
        this.insertedFootnotesLength = lastNode.insertedFootnotes;
        this.footnoteListIndex = lastNode.footnoteListIndex;
        this.footnoteElementIndex = lastNode.footnoteElementIndex;
        int availableBPD = this.getLineWidth(lastNode.line);
        int split = 0;
        KnuthPageNode prevNode = lastNode;
        while (this.insertedFootnotesLength < this.totalFootnotesLength) {
            if (this.totalFootnotesLength - this.insertedFootnotesLength <= availableBPD) {
                this.insertedFootnotesLength = this.totalFootnotesLength;
                this.footnoteListIndex = this.lengthList.size() - 1;
                this.footnoteElementIndex = this.getFootnoteList(this.footnoteListIndex).size() - 1;
                continue;
            }
            split = this.getFootnoteSplit(this.footnoteListIndex, this.footnoteElementIndex, this.insertedFootnotesLength, availableBPD, true);
            if (split > 0) {
                availableBPD -= split;
                this.insertedFootnotesLength += split;
                continue;
            }
            node = (KnuthPageNode)this.createNode(lastNode.position, prevNode.line + 1, 1, this.insertedFootnotesLength - prevNode.insertedFootnotes, 0, 0, 0.0, 0, 0, 0, 0.0, prevNode);
            this.addNode(node.line, node);
            this.removeNode(prevNode.line, prevNode);
            prevNode = node;
            availableBPD = this.getLineWidth(node.line);
        }
        node = (KnuthPageNode)this.createNode(lastNode.position, prevNode.line + 1, 1, this.totalFootnotesLength - prevNode.insertedFootnotes, 0, 0, 0.0, 0, 0, 0, 0.0, prevNode);
        this.addNode(node.line, node);
        this.removeNode(prevNode.line, prevNode);
    }

    public LinkedList<AbstractBreaker.PageBreakPosition> getPageBreaks() {
        return this.pageBreaks;
    }

    public void insertPageBreakAsFirst(AbstractBreaker.PageBreakPosition pageBreak) {
        if (this.pageBreaks == null) {
            this.pageBreaks = new LinkedList();
        }
        this.pageBreaks.addFirst(pageBreak);
    }

    public void removeAllPageBreaks() {
        if (this.pageBreaks == null || this.pageBreaks.isEmpty()) {
            return;
        }
        this.pageBreaks.subList(0, this.pageBreaks.size() - 1).clear();
    }

    @Override
    public void updateData1(int total, double demerits) {
    }

    @Override
    public void updateData2(BreakingAlgorithm.KnuthNode bestActiveNode, KnuthSequence sequence, int total) {
        KnuthPageNode pageNode = (KnuthPageNode)bestActiveNode;
        KnuthPageNode previousPageNode = (KnuthPageNode)pageNode.previous;
        for (WhitespaceManagementPenalty.Variant var : previousPageNode.pendingVariants) {
            WhitespaceManagementPenalty penalty = var.getWhitespaceManagementPenalty();
            if (penalty.hasActiveVariant()) continue;
            penalty.setActiveVariant(var);
        }
        int difference = bestActiveNode.difference;
        if (difference + bestActiveNode.availableShrink < 0 && !this.autoHeight && this.layoutListener != null) {
            this.layoutListener.notifyOverflow(bestActiveNode.line - 1, -difference, this.getFObj());
        }
        boolean isNonLastPage = bestActiveNode.line < total;
        int blockAlignment = isNonLastPage ? this.alignment : this.alignmentLast;
        double ratio = bestActiveNode.adjustRatio;
        if (ratio < 0.0) {
            difference = 0;
        } else if (ratio <= 1.0 && isNonLastPage) {
            difference = 0;
        } else if (ratio > 1.0) {
            ratio = 1.0;
            difference -= bestActiveNode.availableStretch;
        } else if (blockAlignment != 70) {
            ratio = 0.0;
        } else {
            difference = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BBA> difference=" + difference + " ratio=" + ratio + " position=" + bestActiveNode.position));
        }
        if (this.handlingFloat() && this.floatPosition == null) {
            this.floatPosition = new AbstractBreaker.FloatPosition(this.topLevelLM, bestActiveNode.position, ratio, difference);
        } else {
            int firstElementIndex;
            boolean useRelayedFootnotes = this.relayingFootnotes && bestActiveNode.previous.position == 0;
            int firstListIndex = useRelayedFootnotes ? this.previousFootnoteListIndex : ((KnuthPageNode)bestActiveNode.previous).footnoteListIndex;
            int n = firstElementIndex = useRelayedFootnotes ? this.previousFootnoteElementIndex : ((KnuthPageNode)bestActiveNode.previous).footnoteElementIndex;
            if (useRelayedFootnotes) {
                this.previousFootnoteListIndex = -2;
                this.previousFootnoteElementIndex = -2;
                this.relayingFootnotes = false;
            }
            if (this.footnotesList != null && firstElementIndex == this.getFootnoteList(firstListIndex).size() - 1) {
                ++firstListIndex;
                firstElementIndex = 0;
            } else {
                ++firstElementIndex;
            }
            this.insertPageBreakAsFirst(new AbstractBreaker.PageBreakPosition(this.topLevelLM, bestActiveNode.position, firstListIndex, firstElementIndex, ((KnuthPageNode)bestActiveNode).footnoteListIndex, ((KnuthPageNode)bestActiveNode).footnoteElementIndex, ratio, difference));
        }
    }

    @Override
    protected int filterActiveNodes() {
        BreakingAlgorithm.KnuthNode bestActiveNode = null;
        for (int i = this.startLine; i < this.endLine; ++i) {
            BreakingAlgorithm.KnuthNode node = this.getNode(i);
            while (node != null) {
                if (!this.favorSinglePart || node.line <= 1 || bestActiveNode == null || Math.abs(bestActiveNode.difference) >= bestActiveNode.availableShrink) {
                    bestActiveNode = this.compareNodes(bestActiveNode, node);
                }
                if (node != bestActiveNode) {
                    this.removeNode(i, node);
                }
                node = node.next;
            }
        }
        assert (bestActiveNode != null);
        return bestActiveNode.line;
    }

    protected final List<KnuthElement> getFootnoteList(int index) {
        return this.footnotesList.get(index);
    }

    public FObj getFObj() {
        return this.topLevelLM.getFObj();
    }

    @Override
    protected int getLineWidth(int line) {
        int bpd = this.pageProvider != null ? this.pageProvider.getAvailableBPD(line) : super.getLineWidth(line);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getLineWidth(" + line + ") -> " + bpd));
        }
        return bpd;
    }

    @Override
    protected BreakingAlgorithm.KnuthNode recoverFromOverflow() {
        if (this.compareIPDs(this.getLastTooLong().line - 1) != 0) {
            return this.getLastTooLong();
        }
        return super.recoverFromOverflow();
    }

    @Override
    protected int getIPDdifference() {
        return this.ipdDifference;
    }

    @Override
    protected int handleIpdChange() {
        log.trace((Object)("Best node for ipd change:" + this.bestNodeForIPDChange));
        this.calculateBreakPoints(this.bestNodeForIPDChange, this.par, this.bestNodeForIPDChange.line + 1);
        this.activeLines = null;
        return this.bestNodeForIPDChange.line;
    }

    @Override
    protected void addNode(int line, BreakingAlgorithm.KnuthNode node) {
        if (node.position < this.par.size() - 1 && line > 0 && (this.ipdDifference = this.compareIPDs(line - 1)) != 0) {
            log.trace((Object)("IPD changes at page " + line));
            if (this.bestNodeForIPDChange == null || node.totalDemerits < this.bestNodeForIPDChange.totalDemerits) {
                this.bestNodeForIPDChange = node;
            }
        } else {
            if (node.position == this.par.size() - 1) {
                this.ipdDifference = 0;
            } else if (line > 0) {
                this.bestNodeForLastPage = node;
            }
            super.addNode(line, node);
        }
    }

    BreakingAlgorithm.KnuthNode getBestNodeBeforeIPDChange() {
        return this.bestNodeForIPDChange;
    }

    private int compareIPDs(int line) {
        if (this.pageProvider == null) {
            return 0;
        }
        return this.pageProvider.compareIPDs(line);
    }

    BreakingAlgorithm.KnuthNode getBestNodeForLastPage() {
        return this.bestNodeForLastPage;
    }

    @Override
    protected boolean handlingFloat() {
        return this.handlingStartOfFloat || this.handlingEndOfFloat;
    }

    @Override
    protected void createForcedNodes(BreakingAlgorithm.KnuthNode node, int line, int elementIdx, int difference, double r, double demerits, int fitnessClass, int availableShrink, int availableStretch, int newWidth, int newStretch, int newShrink) {
        if (this.handlingFloat()) {
            if (this.bestFloatEdgeNode == null || demerits <= this.bestFloatEdgeNode.totalDemerits) {
                this.bestFloatEdgeNode = this.createNode(elementIdx, line + 1, fitnessClass, newWidth, newStretch, newShrink, r, availableShrink, availableStretch, difference, demerits, node);
            }
        } else {
            super.createForcedNodes(node, line, elementIdx, difference, r, demerits, fitnessClass, availableShrink, availableStretch, newWidth, newStretch, newShrink);
        }
    }

    @Override
    protected int handleFloat() {
        this.calculateBreakPoints(this.bestFloatEdgeNode, this.par, this.bestFloatEdgeNode.line);
        this.activeLines = null;
        return this.bestFloatEdgeNode.line - 1;
    }

    protected BreakingAlgorithm.KnuthNode getBestFloatEdgeNode() {
        return this.bestFloatEdgeNode;
    }

    protected AbstractBreaker.FloatPosition getFloatPosition() {
        return this.floatPosition;
    }

    protected int getFloatHeight() {
        return this.floatHeight;
    }

    protected boolean handlingStartOfFloat() {
        return this.handlingStartOfFloat;
    }

    protected boolean handlingEndOfFloat() {
        return this.handlingEndOfFloat;
    }

    @Override
    protected void deactivateNode(BreakingAlgorithm.KnuthNode node, int line) {
        super.deactivateNode(node, line);
        if (this.handlingEndOfFloat) {
            this.floatHeight = this.totalWidth;
        }
    }

    @Override
    protected void disableFloatHandling() {
        this.handlingEndOfFloat = false;
        this.handlingStartOfFloat = false;
    }

    public void loadFootnotes(List fl, List<Integer> ll, int tfl, int ifl, boolean fp, boolean nf, int fnfi, int fli, int fei, MinOptMax fsl, int pfli, int pfei) {
        this.footnotesList = fl;
        this.lengthList = ll;
        this.totalFootnotesLength = tfl;
        this.insertedFootnotesLength = ifl;
        this.footnotesPending = fp;
        this.newFootnotes = nf;
        this.firstNewFootnoteIndex = fnfi;
        this.footnoteListIndex = fli;
        this.footnoteElementIndex = fei;
        this.footnoteSeparatorLength = fsl;
        this.previousFootnoteListIndex = pfli;
        this.previousFootnoteElementIndex = pfei;
        this.relayingFootnotes = this.previousFootnoteListIndex != -2 || this.previousFootnoteElementIndex != -2;
    }

    public void relayFootnotes(PageSequenceLayoutManager pslm) {
        if (!this.relayingFootnotes && this.bestFloatEdgeNode != null) {
            this.previousFootnoteListIndex = ((KnuthPageNode)this.bestFloatEdgeNode.previous).footnoteListIndex;
            this.previousFootnoteElementIndex = ((KnuthPageNode)this.bestFloatEdgeNode.previous).footnoteElementIndex;
        }
        pslm.holdFootnotes(this.footnotesList, this.lengthList, this.totalFootnotesLength, this.insertedFootnotesLength, this.footnotesPending, this.newFootnotes, this.firstNewFootnoteIndex, this.footnoteListIndex, this.footnoteElementIndex, this.footnoteSeparatorLength, this.previousFootnoteListIndex, this.previousFootnoteElementIndex);
    }

    public static interface PageBreakingLayoutListener {
        public void notifyOverflow(int var1, int var2, FObj var3);
    }

    protected class BestPageRecords
    extends BreakingAlgorithm.BestRecords {
        private final int[] bestInsertedFootnotesLength = new int[4];
        private final int[] bestTotalFootnotesLength = new int[4];
        private final int[] bestFootnoteListIndex = new int[4];
        private final int[] bestFootnoteElementIndex = new int[4];

        protected BestPageRecords() {
        }

        @Override
        public void addRecord(double demerits, BreakingAlgorithm.KnuthNode node, double adjust, int availableShrink, int availableStretch, int difference, int fitness) {
            super.addRecord(demerits, node, adjust, availableShrink, availableStretch, difference, fitness);
            this.bestInsertedFootnotesLength[fitness] = PageBreakingAlgorithm.this.insertedFootnotesLength;
            this.bestTotalFootnotesLength[fitness] = PageBreakingAlgorithm.this.totalFootnotesLength;
            this.bestFootnoteListIndex[fitness] = PageBreakingAlgorithm.this.footnoteListIndex;
            this.bestFootnoteElementIndex[fitness] = PageBreakingAlgorithm.this.footnoteElementIndex;
        }

        public int getInsertedFootnotesLength(int fitness) {
            return this.bestInsertedFootnotesLength[fitness];
        }

        public int getTotalFootnotesLength(int fitness) {
            return this.bestTotalFootnotesLength[fitness];
        }

        public int getFootnoteListIndex(int fitness) {
            return this.bestFootnoteListIndex[fitness];
        }

        public int getFootnoteElementIndex(int fitness) {
            return this.bestFootnoteElementIndex[fitness];
        }
    }

    protected class KnuthPageNode
    extends BreakingAlgorithm.KnuthNode {
        public int insertedFootnotes;
        public int totalFootnotes;
        public int footnoteListIndex;
        public int footnoteElementIndex;
        private final List<WhitespaceManagementPenalty.Variant> pendingVariants;
        private int totalVariantsWidth;

        public KnuthPageNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink, int insertedFootnotes, int totalFootnotes, int footnoteListIndex, int footnoteElementIndex, double adjustRatio, int availableShrink, int availableStretch, int difference, double totalDemerits, BreakingAlgorithm.KnuthNode previous) {
            super(position, line, fitness, totalWidth, totalStretch, totalShrink, adjustRatio, availableShrink, availableStretch, difference, totalDemerits, previous);
            this.pendingVariants = new ArrayList<WhitespaceManagementPenalty.Variant>();
            this.totalFootnotes = totalFootnotes;
            this.insertedFootnotes = insertedFootnotes;
            this.footnoteListIndex = footnoteListIndex;
            this.footnoteElementIndex = footnoteElementIndex;
        }

        public void addVariant(WhitespaceManagementPenalty.Variant variant) {
            this.pendingVariants.add(variant);
            this.totalVariantsWidth += variant.width;
        }
    }
}

