/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentLifecycle;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.ObjectReference;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stored<T>
extends AbstractBehavior<T> {
    private final ObjectReference<Instance<T>> instanceReference;
    private final ComponentLifecycle lifecycleDelegate;

    public Stored(ComponentAdapter<T> delegate, ObjectReference<Instance<T>> reference) {
        super(delegate);
        this.instanceReference = reference;
        this.lifecycleDelegate = Stored.hasLifecycle(delegate) ? new RealComponentLifecycle() : new NoComponentLifecycle();
    }

    private void guardInstRef() {
        if (this.instanceReference.get() == null) {
            this.instanceReference.set(new Instance());
        }
    }

    @Override
    public boolean componentHasLifecycle() {
        return this.lifecycleDelegate.componentHasLifecycle();
    }

    @Override
    public void dispose(PicoContainer container) {
        this.lifecycleDelegate.dispose(container);
    }

    public T getStoredObject() {
        this.guardInstRef();
        return (T)((Instance)this.instanceReference.get()).instance;
    }

    public void flush() {
        Instance<T> inst = this.instanceReference.get();
        if (inst != null) {
            Object instance = ((Instance)inst).instance;
            if (instance != null && this.instanceReference.get().started) {
                this.stop(instance);
                this.dispose(instance);
            }
            this.instanceReference.set(null);
        }
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        this.guardInstRef();
        Object instance = ((Instance)this.instanceReference.get()).instance;
        if (instance == null) {
            instance = super.getComponentInstance(container, into);
            ((Instance)this.instanceReference.get()).instance = instance;
        }
        return (T)instance;
    }

    @Override
    public String getDescriptor() {
        return "Stored" + this.getLifecycleDescriptor();
    }

    protected String getLifecycleDescriptor() {
        return this.lifecycleDelegate.componentHasLifecycle() ? "+Lifecycle" : "";
    }

    @Override
    public void start(PicoContainer container) {
        this.lifecycleDelegate.start(container);
    }

    @Override
    public void stop(PicoContainer container) {
        this.lifecycleDelegate.stop(container);
    }

    @Override
    public boolean isStarted() {
        return this.lifecycleDelegate.isStarted();
    }

    private static boolean hasLifecycle(ComponentAdapter delegate) {
        return delegate instanceof LifecycleStrategy && ((LifecycleStrategy)((Object)delegate)).hasLifecycle(delegate.getComponentImplementation());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Instance<T>
    implements Serializable {
        private T instance;
        protected boolean started;
        protected boolean disposed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoComponentLifecycle<T>
    implements ComponentLifecycle<T>,
    Serializable {
        private NoComponentLifecycle() {
        }

        @Override
        public void start(PicoContainer container) {
        }

        @Override
        public void stop(PicoContainer container) {
        }

        @Override
        public void dispose(PicoContainer container) {
        }

        @Override
        public boolean componentHasLifecycle() {
            return false;
        }

        @Override
        public boolean isStarted() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RealComponentLifecycle<T>
    implements ComponentLifecycle<T>,
    Serializable {
        private RealComponentLifecycle() {
        }

        @Override
        public void start(PicoContainer container) {
            Stored.this.guardInstRef();
            this.guardAlreadyDisposed();
            this.guardStartState(true, "already started");
            Stored.this.start(Stored.this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class)));
            ((Instance)((Stored)Stored.this).instanceReference.get()).started = true;
        }

        @Override
        public void stop(PicoContainer container) {
            Stored.this.guardInstRef();
            this.guardAlreadyDisposed();
            this.guardNotInstantiated();
            this.guardStartState(false, "not started");
            Stored.this.stop(((Instance)Stored.this.instanceReference.get()).instance);
            ((Instance)((Stored)Stored.this).instanceReference.get()).started = false;
        }

        @Override
        public void dispose(PicoContainer container) {
            Stored.this.guardInstRef();
            Instance instance = (Instance)Stored.this.instanceReference.get();
            if (instance.instance != null) {
                this.guardAlreadyDisposed();
                Stored.this.dispose(instance.instance);
                instance.disposed = true;
            }
        }

        private void guardNotInstantiated() {
            if (((Instance)Stored.this.instanceReference.get()).instance == null) {
                throw new IllegalStateException("'" + Stored.this.getComponentKey() + "' not instantiated");
            }
        }

        private void guardStartState(boolean unexpectedStartState, String message) {
            if (((Instance)((Stored)Stored.this).instanceReference.get()).started == unexpectedStartState) {
                throw new IllegalStateException("'" + Stored.this.getComponentKey() + "' " + message);
            }
        }

        private void guardAlreadyDisposed() {
            if (((Instance)((Stored)Stored.this).instanceReference.get()).disposed) {
                throw new IllegalStateException("'" + Stored.this.getComponentKey() + "' already disposed");
            }
        }

        @Override
        public boolean componentHasLifecycle() {
            return true;
        }

        @Override
        public boolean isStarted() {
            Stored.this.guardInstRef();
            return ((Instance)((Stored)Stored.this).instanceReference.get()).started;
        }
    }
}

