/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.OCFResource;
import com.adobe.epubcheck.ocf.OCFResources;
import com.adobe.epubcheck.util.FeatureEnum;
import com.google.common.collect.ImmutableMap;
import io.mola.galimatias.URL;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class OCFDirectoryResources
implements OCFResources {
    private final Path root;

    public OCFDirectoryResources(URL rootURL) throws IOException {
        try {
            this.root = Paths.get(rootURL.toJavaURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot convert the container URL to a path", e);
        }
        if (!Files.isDirectory(this.root, new LinkOption[0])) {
            throw new IllegalArgumentException("The container root must be a directory");
        }
    }

    @Override
    public Iterator<OCFResource> iterator() {
        Iterator paths;
        try {
            paths = Files.walk(this.root, new FileVisitOption[0]).iterator();
            paths.next();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Iterator<OCFResource>(){

            @Override
            public boolean hasNext() {
                return paths.hasNext();
            }

            @Override
            public OCFResource next() throws NoSuchElementException {
                final Path path = (Path)paths.next();
                try {
                    final BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    if (attributes.isSymbolicLink()) {
                        throw new UncheckedIOException(new IOException("symbolic links are disallowed"));
                    }
                    ImmutableMap properties = ImmutableMap.builder().put((Object)FeatureEnum.SIZE, (Object)String.valueOf(attributes.size())).put((Object)FeatureEnum.COMPRESSED_SIZE, (Object)String.valueOf(attributes.size())).put((Object)FeatureEnum.COMPRESSION_METHOD, (Object)"Stored").put((Object)FeatureEnum.SHA_256, (Object)OCFDirectoryResources.getSHAHash(path)).put((Object)FeatureEnum.CREATION_DATE, (Object)attributes.creationTime().toString()).build();
                    return new OCFResource(){
                        final /* synthetic */ Map val$properties;
                        {
                            this.val$properties = map;
                        }

                        @Override
                        public InputStream openStream() throws IOException {
                            return Files.newInputStream(path, new OpenOption[0]);
                        }

                        @Override
                        public boolean isFile() {
                            return attributes.isRegularFile();
                        }

                        @Override
                        public boolean isDirectory() {
                            return attributes.isDirectory();
                        }

                        @Override
                        public Map<FeatureEnum, String> getProperties() {
                            return this.val$properties;
                        }

                        @Override
                        public String getPath() {
                            return StreamSupport.stream(OCFDirectoryResources.this.root.relativize(path).spliterator(), false).map(Path::toString).collect(Collectors.joining("/"));
                        }

                        public String toString() {
                            return this.getPath();
                        }
                    };
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
    }

    private static String getSHAHash(Path path) {
        String string;
        block8: {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                string = OCFResources.getSHAHash(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "";
                }
            }
            inputStream.close();
        }
        return string;
    }
}

