/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.plugin.Options;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ExitStatus
implements ConcurrentEventListener {
    private static final byte DEFAULT = 0;
    private static final byte ERRORS = 1;
    private final List<Result> results = new ArrayList<Result>();
    private final Options options;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = event -> this.results.add(event.getResult());

    public ExitStatus(Options options) {
        this.options = options;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    byte exitStatus() {
        return this.isSuccess() ? (byte)0 : 1;
    }

    boolean isSuccess() {
        if (this.results.isEmpty()) {
            return true;
        }
        if (this.options.isWip()) {
            Result leastSeverResult = Collections.min(this.results, Comparator.comparing(Result::getStatus));
            return !leastSeverResult.getStatus().is(Status.PASSED);
        }
        Result mostSevereResult = Collections.max(this.results, Comparator.comparing(Result::getStatus));
        return mostSevereResult.getStatus().isOk();
    }

    Status getStatus() {
        if (this.results.isEmpty()) {
            return Status.PASSED;
        }
        Result mostSevereResult = Collections.max(this.results, Comparator.comparing(Result::getStatus));
        return mostSevereResult.getStatus();
    }
}

