# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network watcher flow-log list",
)
class List(AAZCommand):
    """List all flow log resources for the specified Network Watcher.

    :example: List all flow log resources for the specified Network Watcher.
        az network watcher flow-log list --location westus2
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/flowlogs", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_PAGINATION = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_paging(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.network_watcher_name = AAZStrArg(
            options=["--network-watcher-name"],
            help="The name of the Network Watcher resource.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.FlowLogsList(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        next_link = self.deserialize_output(self.ctx.vars.instance.next_link)
        return result, next_link

    class FlowLogsList(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.network_watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.value = AAZListType()

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.location = AAZStrType()
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.tags = AAZDictType()
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.enabled = AAZBoolType()
            properties.flow_analytics_configuration = AAZObjectType(
                serialized_name="flowAnalyticsConfiguration",
            )
            properties.format = AAZObjectType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.retention_policy = AAZObjectType(
                serialized_name="retentionPolicy",
            )
            properties.storage_id = AAZStrType(
                serialized_name="storageId",
                flags={"required": True},
            )
            properties.target_resource_guid = AAZStrType(
                serialized_name="targetResourceGuid",
                flags={"read_only": True},
            )
            properties.target_resource_id = AAZStrType(
                serialized_name="targetResourceId",
                flags={"required": True},
            )

            flow_analytics_configuration = cls._schema_on_200.value.Element.properties.flow_analytics_configuration
            flow_analytics_configuration.network_watcher_flow_analytics_configuration = AAZObjectType(
                serialized_name="networkWatcherFlowAnalyticsConfiguration",
            )

            network_watcher_flow_analytics_configuration = cls._schema_on_200.value.Element.properties.flow_analytics_configuration.network_watcher_flow_analytics_configuration
            network_watcher_flow_analytics_configuration.enabled = AAZBoolType()
            network_watcher_flow_analytics_configuration.traffic_analytics_interval = AAZIntType(
                serialized_name="trafficAnalyticsInterval",
            )
            network_watcher_flow_analytics_configuration.workspace_id = AAZStrType(
                serialized_name="workspaceId",
            )
            network_watcher_flow_analytics_configuration.workspace_region = AAZStrType(
                serialized_name="workspaceRegion",
            )
            network_watcher_flow_analytics_configuration.workspace_resource_id = AAZStrType(
                serialized_name="workspaceResourceId",
            )

            format = cls._schema_on_200.value.Element.properties.format
            format.type = AAZStrType()
            format.version = AAZIntType()

            retention_policy = cls._schema_on_200.value.Element.properties.retention_policy
            retention_policy.days = AAZIntType()
            retention_policy.enabled = AAZBoolType()

            tags = cls._schema_on_200.value.Element.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""


__all__ = ["List"]
