# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from . import models as _models
from ._configuration import StorageManagementClientConfiguration
from ._utils.serialization import Deserializer, Serializer
from .operations import (
    BlobContainersOperations,
    BlobInventoryPoliciesOperations,
    BlobServicesOperations,
    DeletedAccountsOperations,
    EncryptionScopesOperations,
    FileServicesOperations,
    FileSharesOperations,
    LocalUsersOperations,
    ManagementPoliciesOperations,
    NetworkSecurityPerimeterConfigurationsOperations,
    ObjectReplicationPoliciesOperations,
    Operations,
    PrivateEndpointConnectionsOperations,
    PrivateLinkResourcesOperations,
    QueueOperations,
    QueueServicesOperations,
    SkusOperations,
    StorageAccountsOperations,
    StorageTaskAssignmentInstancesReportOperations,
    StorageTaskAssignmentsInstancesReportOperations,
    StorageTaskAssignmentsOperations,
    TableOperations,
    TableServicesOperations,
    UsagesOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class StorageManagementClient:  # pylint: disable=too-many-instance-attributes
    """The Azure Storage Management API.

    :ivar blob_services: BlobServicesOperations operations
    :vartype blob_services: azure.mgmt.storage.operations.BlobServicesOperations
    :ivar blob_containers: BlobContainersOperations operations
    :vartype blob_containers: azure.mgmt.storage.operations.BlobContainersOperations
    :ivar file_services: FileServicesOperations operations
    :vartype file_services: azure.mgmt.storage.operations.FileServicesOperations
    :ivar file_shares: FileSharesOperations operations
    :vartype file_shares: azure.mgmt.storage.operations.FileSharesOperations
    :ivar queue_services: QueueServicesOperations operations
    :vartype queue_services: azure.mgmt.storage.operations.QueueServicesOperations
    :ivar queue: QueueOperations operations
    :vartype queue: azure.mgmt.storage.operations.QueueOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.storage.operations.Operations
    :ivar skus: SkusOperations operations
    :vartype skus: azure.mgmt.storage.operations.SkusOperations
    :ivar storage_accounts: StorageAccountsOperations operations
    :vartype storage_accounts: azure.mgmt.storage.operations.StorageAccountsOperations
    :ivar deleted_accounts: DeletedAccountsOperations operations
    :vartype deleted_accounts: azure.mgmt.storage.operations.DeletedAccountsOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.storage.operations.UsagesOperations
    :ivar management_policies: ManagementPoliciesOperations operations
    :vartype management_policies: azure.mgmt.storage.operations.ManagementPoliciesOperations
    :ivar blob_inventory_policies: BlobInventoryPoliciesOperations operations
    :vartype blob_inventory_policies: azure.mgmt.storage.operations.BlobInventoryPoliciesOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.storage.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources: azure.mgmt.storage.operations.PrivateLinkResourcesOperations
    :ivar object_replication_policies: ObjectReplicationPoliciesOperations operations
    :vartype object_replication_policies:
     azure.mgmt.storage.operations.ObjectReplicationPoliciesOperations
    :ivar local_users: LocalUsersOperations operations
    :vartype local_users: azure.mgmt.storage.operations.LocalUsersOperations
    :ivar encryption_scopes: EncryptionScopesOperations operations
    :vartype encryption_scopes: azure.mgmt.storage.operations.EncryptionScopesOperations
    :ivar table_services: TableServicesOperations operations
    :vartype table_services: azure.mgmt.storage.operations.TableServicesOperations
    :ivar table: TableOperations operations
    :vartype table: azure.mgmt.storage.operations.TableOperations
    :ivar network_security_perimeter_configurations:
     NetworkSecurityPerimeterConfigurationsOperations operations
    :vartype network_security_perimeter_configurations:
     azure.mgmt.storage.operations.NetworkSecurityPerimeterConfigurationsOperations
    :ivar storage_task_assignments: StorageTaskAssignmentsOperations operations
    :vartype storage_task_assignments:
     azure.mgmt.storage.operations.StorageTaskAssignmentsOperations
    :ivar storage_task_assignments_instances_report:
     StorageTaskAssignmentsInstancesReportOperations operations
    :vartype storage_task_assignments_instances_report:
     azure.mgmt.storage.operations.StorageTaskAssignmentsInstancesReportOperations
    :ivar storage_task_assignment_instances_report: StorageTaskAssignmentInstancesReportOperations
     operations
    :vartype storage_task_assignment_instances_report:
     azure.mgmt.storage.operations.StorageTaskAssignmentInstancesReportOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2024-01-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "TokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = StorageManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, credential_scopes=credential_scopes, **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, base_url), policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.blob_services = BlobServicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.blob_containers = BlobContainersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.file_services = FileServicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.file_shares = FileSharesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.queue_services = QueueServicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.queue = QueueOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.skus = SkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.storage_accounts = StorageAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.deleted_accounts = DeletedAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.management_policies = ManagementPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.blob_inventory_policies = BlobInventoryPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.object_replication_policies = ObjectReplicationPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.local_users = LocalUsersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.encryption_scopes = EncryptionScopesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.table_services = TableServicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.table = TableOperations(self._client, self._config, self._serialize, self._deserialize)
        self.network_security_perimeter_configurations = NetworkSecurityPerimeterConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.storage_task_assignments = StorageTaskAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.storage_task_assignments_instances_report = StorageTaskAssignmentsInstancesReportOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.storage_task_assignment_instances_report = StorageTaskAssignmentInstancesReportOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
